
/*:

@target MZ
@plugindesc セルフスイッチを一括で変更できます。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@param variable
@text 変数名
@desc <[変数名]:[種類]>の変数名を指定できます。（初期変数名:mk_selfSwitches）
@type string
@default mk_selfSwitches

@help MK_SelfSwitches.js

セルフスイッチを一括で変更できます。

イベントのメモ:

<mk_selfSwitches:[種類]>:
イベントの種類を設定します。
mk_selfSwitchesはパラメーターで変えれます。


@command nowMap
@text 今いるマップのセルフスイッチ変更
@desc 今いるマップのイベントのセルフスイッチを変更できます。

@arg switches
@text セルフスイッチ
@desc 操作するセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

@arg operation
@text 操作
@desc 指定したセルフスイッチをONかOFFにします。
@type boolean
@default true

@command nowTypeMap
@text 今いるマップの特定のセルフスイッチ変更
@desc 今いるマップの指定した種類のイベントのセルフスイッチを変更できます。

@arg type
@text 種類
@desc 指定するイベントの種類の名です。
@type string

@arg switches
@text セルフスイッチ
@desc 操作するセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

@arg operation
@text 操作
@desc 指定したセルフスイッチをONかOFFにします。
@type boolean
@default true

@command mapOff
@text 指定マップのセルフスイッチOFF
@desc 指定したマップのイベントのセルフスイッチをOFFにします。

@arg map
@text マップ
@desc 指定するマップのIDです。
@type number
@min 1
@default 1

@arg switches
@text セルフスイッチ
@desc OFFにするセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

@command allMapOff
@text 全マップのセルフスイッチOFF
@desc 全マップのイベントのセルフスイッチをOFFにします。

@arg switches
@text セルフスイッチ
@desc OFFにするセルフスイッチです。
@type select
@option A
@option B
@option C
@option D
@default A

*/

/////////////////グローバルデータ/////////////////
var mk_selfSwitches = new MK_SelfSwitches();

/////////////////セルフスイッチオブジェクト/////////////////

function MK_SelfSwitches() {
    this.mapId = 0;//マップID
    this.events = [];//対象イベントのid
    this.selfSwitches = "A";//対象セルフスイッチ
    this.value = false;//onかoffか
    
    this.parameters = {
        variable : ""
    };
}

//セルフスイッチ切替
MK_SelfSwitches.prototype.Switching = function() {
    for(let r = 0; r < this.events.length; r++){
        $gameSelfSwitches.setValue([this.mapId, this.events[r], this.selfSwitches], this.value);
    }
};

//今いるマップのイベント
MK_SelfSwitches.prototype.NowMap = function(selfSwitches, value) {//対象セルフスイッチ, trueかfalse
    this.mapId = $gameMap.mapId();
    this.events = [];
    const e = $dataMap.events.filter(function(event) {
        return (!!event) ? true : false;
    });
    for(let r = 0; r < e.length; r++){
        this.events.push(e[r].id);
    }
    this.selfSwitches = selfSwitches;
    this.value = value;
    this.Switching();
};

//今いるマップの特定のイベント
MK_SelfSwitches.prototype.NowTypeMap = function(type, selfSwitches, value) {//種類, 対象セルフスイッチ, trueかfalse
    this.mapId = $gameMap.mapId();
    this.events = [];
    const variable = this.parameters.variable;
    const e = $dataMap.events.filter(event => (!!event && event.meta[variable] == type) ? true : false);
    for(let r = 0; r < e.length; r++){
        this.events.push(e[r].id);
    }
    this.selfSwitches = selfSwitches;
    this.value = value;
    this.Switching();
};

//指定したマップのイベントのセルフスイッチ全てOFF
MK_SelfSwitches.prototype.MapOff = function(mapId, selfSwitches) {//マップid, 対象セルフスイッチ
    const selfSwitchesData = Object.keys($gameSelfSwitches._data);
    let name = [];
    let deleteData = [];
    for(let r = 0; r < selfSwitchesData.length; r++){
        name = selfSwitchesData[r].split(",");
        if(name[0] == mapId && selfSwitches == name[2]){
            deleteData.push(selfSwitchesData[r]);
        }
    }
    for(let r = 0; r < deleteData.length; r++){
        delete $gameSelfSwitches._data[deleteData[r]];
    }
    $gameSelfSwitches.onChange();
};

//全マップのイベントのセルフスイッチ全てOFF
MK_SelfSwitches.prototype.AllMapOff = function(selfSwitches) {//対象セルフスイッチ
    const selfSwitchesData = Object.keys($gameSelfSwitches._data);
    let name = [];
    let deleteData = [];
    for(let r = 0; r < selfSwitchesData.length; r++){
        name = selfSwitchesData[r].split(",");
        if(selfSwitches == name[2]){
            deleteData.push(selfSwitchesData[r]);
        }
    }
    for(let r = 0; r < deleteData.length; r++){
        delete $gameSelfSwitches._data[deleteData[r]];
    }
    $gameSelfSwitches.onChange();
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_SelfSwitches";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    mk_selfSwitches.parameters.variable = String(parameters["variable"]) || "mk_selfSwitches";
    
    
    //----------プラグインコマンド----------

    //今いるマップのイベント
    PluginManager.registerCommand(pluginName, "nowMap", args => {
        mk_selfSwitches.NowMap(args.switches, (args.operation == "true") ? true : false);
    });
    
    ///今いるマップの特定のイベント
    PluginManager.registerCommand(pluginName, "nowTypeMap", args => {
        mk_selfSwitches.NowTypeMap(args.type, args.switches, (args.operation == "true") ? true : false);
    });
    
    //指定したマップのイベントのセルフスイッチ全てOFF
    PluginManager.registerCommand(pluginName, "mapOff", args => {
        mk_selfSwitches.MapOff(Number(args.map), args.switches);
    });
    
    //全マップのイベントのセルフスイッチ全てOFF
    PluginManager.registerCommand(pluginName, "allMapOff", args => {
        mk_selfSwitches.MapOff(Number(args.map), args.switches);
        mk_selfSwitches.AllMapOff(args.switches);
    });
    

})();
